/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion;

import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.EnumGetMethod;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.AdvancedPath;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.Conversion;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.Converter;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.InvalidValueException;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.Path;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.PreserveNotNull;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.ReflectionException;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecClassInArray;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecDoubleInRange;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecEnum;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecFloatInRange;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecIntInRange;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecLongInRange;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecNotNull;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecStringInArray;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecStringInRange;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.conversion.SpecValidator;
import club.sk1er.mods.scrollabletooltips.vigilance.impl.nightconfig.core.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static boolean isEnum(Field annotatedElement) {
        return annotatedElement.getType().isEnum() || annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean hasPreserveNotNull(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean mustPreserve(Field field2, Class<?> fieldClass) {
        return AnnotationUtils.hasPreserveNotNull(field2) || AnnotationUtils.hasPreserveNotNull(fieldClass);
    }

    static Converter<Object, Object> getConverter(Field field2) {
        Conversion conversion = field2.getAnnotation(Conversion.class);
        if (conversion != null) {
            try {
                Constructor<Converter<?, ?>> constructor = conversion.value().getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new ReflectionException("Cannot create a converter for field " + field2, ex);
            }
        }
        return null;
    }

    static List<String> getPath(Field field2) {
        List<String> annotatedPath = AnnotationUtils.getPath((AnnotatedElement)field2);
        return annotatedPath == null ? Collections.singletonList(field2.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        Path path = annotatedElement.getDeclaredAnnotation(Path.class);
        if (path != null) {
            return StringUtils.split(path.value(), '.');
        }
        AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    static void checkField(Field field2, Object value) {
        SpecValidator specValidator;
        SpecEnum specEnum;
        SpecNotNull specNotNull = field2.getDeclaredAnnotation(SpecNotNull.class);
        if (specNotNull != null) {
            AnnotationUtils.checkNotNull(field2, value);
            return;
        }
        SpecClassInArray specClassInArray = field2.getDeclaredAnnotation(SpecClassInArray.class);
        if (specClassInArray != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specClassInArray);
            return;
        }
        SpecStringInArray specStringInArray = field2.getDeclaredAnnotation(SpecStringInArray.class);
        if (specStringInArray != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specStringInArray);
            return;
        }
        SpecStringInRange specStringInRange = field2.getDeclaredAnnotation(SpecStringInRange.class);
        if (specStringInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specStringInRange);
            return;
        }
        SpecDoubleInRange specDoubleInRange = field2.getDeclaredAnnotation(SpecDoubleInRange.class);
        if (specDoubleInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specDoubleInRange);
            return;
        }
        SpecFloatInRange specFloatInRange = field2.getDeclaredAnnotation(SpecFloatInRange.class);
        if (specFloatInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specFloatInRange);
            return;
        }
        SpecLongInRange specLongInRange = field2.getDeclaredAnnotation(SpecLongInRange.class);
        if (specLongInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specLongInRange);
            return;
        }
        SpecIntInRange specIntInRange = field2.getDeclaredAnnotation(SpecIntInRange.class);
        if (specIntInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specIntInRange);
        }
        if ((specEnum = field2.getDeclaredAnnotation(SpecEnum.class)) != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specEnum);
        }
        if ((specValidator = field2.getDeclaredAnnotation(SpecValidator.class)) != null) {
            AnnotationUtils.checkFieldSpec(field2, value, specValidator);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecValidator spec) {
        Predicate<Object> validatorInstance;
        try {
            Constructor<? extends Predicate<Object>> constructor = spec.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            validatorInstance = constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Cannot create a converter for field " + field2, ex);
        }
        if (!validatorInstance.test(value)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecClassInArray spec) {
        AnnotationUtils.checkNotNull(field2, value);
        Class<?> valueClass = value.getClass();
        if (spec.strict()) {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.isAssignableFrom(valueClass)) continue;
                return;
            }
        } else {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.equals(valueClass)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value, field2, spec);
    }

    private static void checkFieldSpec(Field field2, Object value, SpecStringInRange spec) {
        AnnotationUtils.checkClass(field2, value, String.class);
        String s = (String)value;
        if (s.compareTo(spec.min()) < 0 || s.compareTo(spec.max()) > 0) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecEnum spec) {
        EnumGetMethod m = spec.method();
        Class<?> fieldType = field2.getType();
        if (!fieldType.isEnum()) {
            throw new InvalidValueException("Field %s is annotated with @SpecEnum but isn't of type enum", field2);
        }
        Class<?> t = fieldType;
        if (!m.validate(value, t)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecStringInArray spec) {
        AnnotationUtils.checkClass(field2, value, String.class);
        String s = (String)value;
        if (spec.ignoreCase()) {
            for (String acceptable : spec.value()) {
                if (!s.equalsIgnoreCase(acceptable)) continue;
                return;
            }
        } else {
            for (String acceptable : spec.value()) {
                if (!s.equals(acceptable)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value, field2, spec);
    }

    private static void checkFieldSpec(Field field2, Object value, SpecDoubleInRange spec) {
        AnnotationUtils.checkClass(field2, value, Double.class);
        double d = (Double)value;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecFloatInRange spec) {
        AnnotationUtils.checkClass(field2, value, Float.class);
        float d = ((Float)value).floatValue();
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecLongInRange spec) {
        AnnotationUtils.checkClass(field2, value, Long.class);
        long d = (Long)value;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value, SpecIntInRange spec) {
        AnnotationUtils.checkClass(field2, value, Integer.class);
        int d = (Integer)value;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value, field2, spec);
        }
    }

    private static void checkNotNull(Field field2, Object value) {
        if (value == null) {
            throw new InvalidValueException("Invalid null value for field %s", field2);
        }
    }

    private static void checkClass(Field field2, Object value, Class<?> expectedClass) {
        AnnotationUtils.checkNotNull(field2, value);
        Class<?> valueClass = value.getClass();
        if (valueClass != expectedClass) {
            throw new InvalidValueException("Invalid type %s for field %s, expected %s", valueClass, field2, expectedClass);
        }
    }
}

